/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.mojang.blaze3d.platform.InputConstants;
import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.Network;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.Level;

public class KeyHandler {
    private static KeyHandler keyHandler;
    private final Map<KeyMapping, Action> keyBindingMap;

    KeyHandler() {
        InputConstants.Type.MOUSE.m_84895_(99);
        InputConstants.Type.MOUSE.m_84895_(101);
        this.keyBindingMap = Stream.of(Action.values()).map(a -> new AbstractMap.SimpleEntry<Action, KeyMapping>((Action)((Object)a), new KeyMapping(a.getKeyBindingName(), (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.MOUSE, a.getDefaultKeyCode(), "keygroup.inventorysorter"))).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.keyBindingMap.keySet().forEach(ClientRegistry::registerKeyBinding);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onKey);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onMouse);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onScroll);
    }

    static void init() {
        keyHandler = new KeyHandler();
    }

    private void onKey(ScreenEvent.KeyboardKeyPressedEvent.Pre evt) {
        this.onInputEvent(evt, this::keyEvaluate);
    }

    private void onMouse(ScreenEvent.MouseClickedEvent.Pre evt) {
        this.onInputEvent(evt, this::mouseClickEvaluate);
    }

    private void onScroll(ScreenEvent.MouseScrollEvent.Post evt) {
        this.onInputEvent(evt, this::mouseScrollEvaluate);
    }

    private boolean keyEvaluate(KeyMapping kb, ScreenEvent.KeyboardKeyPressedEvent.Pre evt) {
        return kb.m_90832_(evt.getKeyCode(), evt.getScanCode());
    }

    private boolean mouseClickEvaluate(KeyMapping kb, ScreenEvent.MouseClickedEvent.Pre evt) {
        return kb.m_90830_(evt.getButton());
    }

    private boolean mouseScrollEvaluate(KeyMapping kb, ScreenEvent.MouseScrollEvent.Post evt) {
        int dir = (int)Math.signum(evt.getScrollDelta());
        int keycode = dir + 100;
        return kb.m_90830_(keycode);
    }

    private <T extends ScreenEvent> void onInputEvent(T evt, BiPredicate<KeyMapping, T> kbTest) {
        Screen gui = evt.getScreen();
        if (!(gui instanceof AbstractContainerScreen) || gui instanceof CreativeModeInventoryScreen) {
            return;
        }
        AbstractContainerScreen guiContainer = (AbstractContainerScreen)gui;
        Slot slot = guiContainer.getSlotUnderMouse();
        if (!ContainerContext.validSlot(slot)) {
            InventorySorter.LOGGER.log(Level.DEBUG, "Skipping action handling for blacklisted slot");
            return;
        }
        Optional<Action> action = this.keyBindingMap.entrySet().stream().filter(e -> kbTest.test((KeyMapping)e.getKey(), evt)).map(Map.Entry::getValue).findFirst();
        if (!action.isPresent()) {
            return;
        }
        Action triggeredAction = action.get();
        if (triggeredAction.isActive() && guiContainer.m_6262_() != null && guiContainer.m_6262_().f_38839_ != null && guiContainer.m_6262_().f_38839_.contains((Object)slot)) {
            InventorySorter.LOGGER.debug("Sending action {} slot {}", (Object)triggeredAction, (Object)slot.f_40219_);
            Network.channel.sendToServer((Object)triggeredAction.message(slot));
            evt.setCanceled(true);
        }
    }
}

